# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""channelLimits userdefined property type, originally defined in resource
file set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class channelLimits(izot.resources.base.Structure):
    """channelLimits userdefined property type.  ."""

    def __init__(self):
        super().__init__(
            key=14,
            scope=4
        )

        self.__highWarning = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('highWarning', self.__highWarning))

        self.__highAlarm = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('highAlarm', self.__highAlarm))

        self.__confirmCount = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=0,
            maximum=65535
        )
        self._register(('confirmCount', self.__confirmCount))

        self.__sentinalSub = izot.resources.base.Scaled(
            size=1,
            signed=False,
            minimum=0,
            maximum=255
        )
        self._register(('sentinalSub', self.__sentinalSub))

        self.__sentinalNode = izot.resources.base.Scaled(
            size=1,
            signed=False,
            minimum=0,
            maximum=255
        )
        self._register(('sentinalNode', self.__sentinalNode))
        self._default_bytes = b'\x00\x00\x00\x00\x00\x00\x00\x00'
        self._original_name = 'UCPTchannelLimits'
        self._property_scope, self._property_key = 4, 14
        self._definition = userdefined.add(self)

    def __set_highWarning(self, v):
        self.__highWarning._value = v

    highWarning = property(
        lambda self: self.__highWarning._value,
        __set_highWarning,
        None,
        """."""
    )

    def __set_highAlarm(self, v):
        self.__highAlarm._value = v

    highAlarm = property(
        lambda self: self.__highAlarm._value,
        __set_highAlarm,
        None,
        """."""
    )

    def __set_confirmCount(self, v):
        self.__confirmCount._value = v

    confirmCount = property(
        lambda self: self.__confirmCount._value,
        __set_confirmCount,
        None,
        """."""
    )

    def __set_sentinalSub(self, v):
        self.__sentinalSub._value = v

    sentinalSub = property(
        lambda self: self.__sentinalSub._value,
        __set_sentinalSub,
        None,
        """."""
    )

    def __set_sentinalNode(self, v):
        self.__sentinalNode._value = v

    sentinalNode = property(
        lambda self: self.__sentinalNode._value,
        __set_sentinalNode,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 8


if __name__ == '__main__':
    # unit test code.
    item = channelLimits()
    pass
